# 機能設計書 54-スペクトル操作（Spectral Operations）

## 概要

本ドキュメントは、TensorFlowにおけるスペクトル操作（フーリエ変換）機能の設計を記述する。FFT・IFFT・RFFT・IRFFT等のフーリエ変換オペレーションを1D・2D・3D・ND対応で提供する。

### 本機能の処理概要

**業務上の目的・背景**：信号処理・画像処理・音声処理において、周波数領域での解析や操作は基本的な要素である。畳み込みの高速化（周波数領域での乗算）、スペクトル分析、フィルタリングなどに利用される。本機能はこれらの基盤となるフーリエ変換オペレーション群を提供する。

**機能の利用シーン**：音声信号のスペクトル分析、画像の周波数領域フィルタリング、畳み込み演算の高速化、科学計算におけるフーリエ解析で利用される。

**主要な処理内容**：
1. 複素FFT/IFFT: 1D, 2D, 3D, ND対応の複素フーリエ変換・逆変換
2. 実数RFFT/IRFFT: 1D, 2D, 3D, ND対応の実数フーリエ変換・逆変換
3. 非推奨BatchFFT系: 旧バージョン互換のバッチフーリエ変換（バージョン15で非推奨）

**関連システム・外部連携**：特になし。内部計算パイプラインで使用される基盤オペレーション。

**権限による制御**：特段の権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面と直接関連しない基盤機能である |

## 機能種別

計算処理 / 信号処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input | Tcomplex/Treal | Yes | 入力テンソル（複素数型または実数型） | FFT: rank>=1, FFT2D: rank>=2, FFT3D: rank>=3 |
| fft_length | int32 | Yes（RFFT系） | FFT長 [rank] | rank=1, dim[0]=対応ランク |
| axes | int32 | Yes（ND系） | FFTを適用する軸 | rank=1 |
| Tcomplex | 型属性 | No | 複素数型（complex64/complex128、デフォルトcomplex64） | - |
| Treal | 型属性 | No | 実数型（float32/float64、デフォルトfloat32） | - |

### 入力データソース

計算グラフ内の前段テンソル（音声波形、画像データ等）。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| output (FFT系) | Tcomplex | フーリエ変換結果（複素数テンソル） |
| output (RFFT) | Tcomplex | 実数FFT結果（最後の次元が fft_length/2 + 1） |
| output (IRFFT) | Treal | 逆実数FFT結果（実数テンソル） |

### 出力先

後続の計算グラフ。

## 処理フロー

### 処理シーケンス

```
1. 入力テンソルの受け取り
   └─ ランク検証（1D/2D/3D/ND対応）
2. FFT長の決定
   ├─ 複素FFT: 入力テンソルの最後の次元をそのまま使用
   └─ RFFT: fft_length入力テンソルから取得
3. フーリエ変換の実行
   ├─ FFT: 複素数→複素数（形状不変）
   ├─ RFFT: 実数→複素数（最後の次元が fft_length/2 + 1）
   ├─ IFFT: 複素数→複素数（形状不変）
   └─ IRFFT: 複素数→実数（最後の次元が fft_length）
4. 出力テンソルの生成
```

### フローチャート

```mermaid
flowchart TD
    A[入力テンソル] --> B{変換種別}
    B -->|FFT/IFFT| C[形状不変: 入力と同じ形状]
    B -->|RFFT| D[最後の次元: fft_length/2 + 1]
    B -->|IRFFT| E[最後の次元: fft_length]
    C --> F[出力テンソル]
    D --> F
    E --> F
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-54-01 | FFT形状不変 | 複素FFT/IFFTは入力と同じ形状を出力する | FFT, IFFT, FFT2D, IFFT2D, FFT3D, IFFT3D |
| BR-54-02 | RFFTハーフスペクトル | RFFTの最後の次元出力サイズは fft_length/2 + 1 | RFFT, RFFT2D, RFFT3D |
| BR-54-03 | IRFFT全スペクトル復元 | IRFFTの最後の次元出力サイズはfft_lengthそのもの | IRFFT, IRFFT2D, IRFFT3D |
| BR-54-04 | fft_length形状検証 | fft_length入力はrank=1でdim[0]=対応FFTランクでなければならない | RFFT/IRFFT系 |
| BR-54-05 | 非推奨Batch系 | BatchFFT/BatchIFFT等はバージョン15で非推奨 | 旧バージョン互換 |

### 計算ロジック

- **FFT**: 離散フーリエ変換 X[k] = sum(x[n] * exp(-2*pi*i*k*n/N))
- **RFFT**: 実数入力のFFT。出力はエルミート対称性を利用してN/2+1点のみ
- **IFFT**: 逆離散フーリエ変換
- **IRFFT**: ハーフスペクトルから実数信号を復元

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgument | ランクエラー | 入力テンソルのランクが不足（FFT: <1, FFT2D: <2, FFT3D: <3） | 十分なランクのテンソルを入力 |
| InvalidArgument | fft_length形状エラー | fft_length入力のrank!=1またはdim[0]!=期待ランク | 正しい形状のfft_lengthを指定 |

### リトライ仕様

ステートレスな計算であり、リトライに特別な考慮は不要。

## トランザクション仕様

トランザクション制御は行わない。

## パフォーマンス要件

FFTはO(N log N)の計算量。GPUカーネル（cuFFT）による高速化が可能。

## セキュリティ考慮事項

特段のセキュリティ考慮事項はない。

## 備考

spectral_ops.ccは約235行で、FFT/IFFT（1D/2D/3D/ND）、RFFT/IRFFT（1D/2D/3D/ND）、および非推奨のBatch系FFTオペレーションを定義している。RFFTShape関数が実数FFTの形状推論のコアロジックを担う。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | spectral_ops.cc | `tensorflow/core/ops/spectral_ops.cc` | 95-130行目: RFFTShape関数 - RFFT/IRFFTの形状推論ロジック。forwardフラグで順変換/逆変換を切り替え |

**読解のコツ**: RFFTShapeのforwardパラメータがtrueの場合、最後の次元が fft_length/2+1 に変換される。falseの場合はfft_lengthそのままが出力次元となる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | spectral_ops.cc | `tensorflow/core/ops/spectral_ops.cc` | 27-33行目: FFT - 1D複素FFT |
| 2-2 | spectral_ops.cc | `tensorflow/core/ops/spectral_ops.cc` | 132-138行目: RFFT - 1D実数FFT |
| 2-3 | spectral_ops.cc | `tensorflow/core/ops/spectral_ops.cc` | 75-93行目: FFTND/IFFTND - N次元対応FFT |

**主要処理フロー**:
1. **27-33行目**: FFT: Tcomplex入力→Tcomplex出力、形状不変（UnchangedShapeWithRankAtLeast(c, 1)）
2. **95-130行目**: RFFTShape: fft_lengthテンソルから各次元のサイズを取得し、forward&&最後の次元の場合のみ fft_length/2+1 に変換
3. **132-138行目**: RFFT: Treal入力→Tcomplex出力、RFFTShape(c, true, 1)で形状推論

### プログラム呼び出し階層図

```
spectral_ops.cc (Op定義)
    |
    +-- 複素FFT系
    |    +-- FFT (27行目) → UnchangedShapeWithRankAtLeast(c, 1)
    |    +-- IFFT (35行目) → UnchangedShapeWithRankAtLeast(c, 1)
    |    +-- FFT2D (43行目) → UnchangedShapeWithRankAtLeast(c, 2)
    |    +-- IFFT2D (51行目) → UnchangedShapeWithRankAtLeast(c, 2)
    |    +-- FFT3D (59行目) → UnchangedShapeWithRankAtLeast(c, 3)
    |    +-- IFFT3D (67行目) → UnchangedShapeWithRankAtLeast(c, 3)
    |    +-- FFTND (75行目) → UnchangedShapeWithRankAtLeast(c, 1)
    |    +-- IFFTND (85行目) → UnchangedShapeWithRankAtLeast(c, 1)
    |
    +-- RFFTShape関数 (95-130行目)
    |    └─ forward/rank パラメータで動作を切り替え
    |
    +-- 実数FFT系
    |    +-- RFFT (132行目) → RFFTShape(c, true, 1)
    |    +-- IRFFT (140行目) → RFFTShape(c, false, 1)
    |    +-- RFFT2D (148行目) → RFFTShape(c, true, 2)
    |    +-- IRFFT2D (156行目) → RFFTShape(c, false, 2)
    |    +-- RFFT3D (164行目) → RFFTShape(c, true, 3)
    |    +-- IRFFT3D (172行目) → RFFTShape(c, false, 3)
    |    +-- RFFTND (180行目) → UnchangedShapeWithRankAtLeast(c, 1)
    |    +-- IRFFTND (191行目) → UnchangedShapeWithRankAtLeast(c, 1)
    |
    +-- 非推奨 Batch系 (203-232行目)
```

### データフロー図

```
[入力]                        [処理]                         [出力]

実数テンソル [.., N] -----> RFFT(fft_length) -----------> 複素テンソル [.., N/2+1]
複素テンソル [.., N/2+1] -> IRFFT(fft_length) ----------> 実数テンソル [.., N]
複素テンソル [.., N] -----> FFT -----------------------> 複素テンソル [.., N]
複素テンソル [.., N] -----> IFFT ----------------------> 複素テンソル [.., N]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| spectral_ops.cc | `tensorflow/core/ops/spectral_ops.cc` | ソース | FFT/RFFT系オペレーション定義（20+ Op） |
| common_shape_fns.h | `tensorflow/core/framework/common_shape_fns.h` | ヘッダ | 共通形状推論関数 |
| numeric_op.h | `tensorflow/core/framework/numeric_op.h` | ヘッダ | 数値演算Op基底 |
